"use client";
import Link from "next/link";
import React from "react";

function MobileView() {

  return (
    <div className="w-full min-h-screen max-h-full overflow-y-auto bg-white px-6">
      <div>
        <Link
          href="/about"
          className="-mx-3 block rounded-lg px-3 py-2 text-base font-semibold leading-7 text-gray-900 hover:text-white hover:bg-golden"
        >
          About
        </Link>
        <div className="-mx-3">
          <Link
            href="/course"
            className="flex w-full items-center gap-4 rounded-lg py-2 pl-3 pr-3.5 text-base font-semibold leading-7 text-gray-900 hover:text-white hover:bg-golden"
          >
            Courses
          </Link>
        </div>
        <Link
          href="#"
          className="-mx-3 block rounded-lg px-3 py-2 text-base font-semibold leading-7 text-gray-900 hover:text-white hover:bg-golden"
        >
          Certifications
        </Link>
        <Link
          href="#"
          className="-mx-3 block rounded-lg px-3 py-2 text-base font-semibold leading-7 text-gray-900 hover:text-white hover:bg-golden"
        >
          Blog
        </Link>
      </div>
      <div className="py-6">
        <Link
          href="#"
          className="-mx-3 block rounded-lg px-3 py-2.5 text-base font-semibold leading-7 text-gray-900 hover:text-white hover:bg-golden"
        >
          Log in
        </Link>
      </div>
    </div>
  );
}

export default MobileView;